/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.snmp;

import com.ibm.hwmca.base.settings.snmp.SnmpConstants;
import com.ibm.hwmca.base.settings.snmp.SnmpErrorIds;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.ArrayList;
import java.util.HashMap;

public class SnmpBean
extends PanelBean
implements SnmpConstants,
SnmpErrorIds {
    private static final String TRACE_MASKT = "XSNMPBNT";
    private static final String TRACE_MASKF = "XSNMPBNF";
    private static final String TRACE_MASKD = "XSNMPBND";
    private static final String SNMP_MESSAGES_FILENAME = "com.ibm.hwmca.base.res.message";
    private static final String SNMP_MESSAGE_BOX_TITLE_KEY = "SNMP.TITLE";
    private static final String SNMP_RESTART_CONSOLE_TEXT_KEY = "SNMP002.TEXT";
    private boolean m_bEnableToggle;
    private String m_sAgentParmsEdit;
    private ItemDescriptor[][] m_idNamesTable;
    private ColumnDescriptor[] m_cdNamesTableStructure;
    private int[] m_iNamesTableSelection;
    private ItemDescriptor[][] m_idTcpipTable;
    private ColumnDescriptor[] m_cdTcpipTableStructure;
    private int[] m_iTcpipTableSelection;
    private ArrayList nameList = new ArrayList();
    private ArrayList addressList = new ArrayList();
    private ArrayList networkMaskList = new ArrayList();
    private ArrayList accessTypeList = new ArrayList();
    private ArrayList tcpipList = new ArrayList();
    private HashMap trapMap = new HashMap();
    private String elementName = "";
    private String appearance;

    public void setEnableToggle(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.setEnableToggle(" + b + ")");
        this.m_bEnableToggle = b;
        Trace.trace(TRACE_MASKT, "<- SnmpBean.setEnableToggle()");
    }

    public boolean isEnableToggle() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.isEnableToggle()");
        return this.m_bEnableToggle;
    }

    public void setAgentParmsEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.setAgentParmsEdit(" + s + ")");
        this.m_sAgentParmsEdit = s;
        Trace.trace(TRACE_MASKT, "<- SnmpBean.setAgentParmsEdit()");
    }

    public String getAgentParmsEdit() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getAgentParmsEdit()");
        return this.m_sAgentParmsEdit;
    }

    public void setNamesTableSelection(int[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.setNamesTableSelection(" + selected + ")");
        this.m_iNamesTableSelection = selected;
        Trace.trace(TRACE_MASKT, "<- SnmpBean.setNamesTableSelection()");
    }

    public int[] getNamesTableSelection() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getNamesTableSelection()");
        return this.m_iNamesTableSelection;
    }

    public ItemDescriptor[] getNamesTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getNamesTableRowAt(" + index + ")");
        return this.m_idNamesTable[index];
    }

    public void setNamesTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.setNamesTableRowAt(" + index + ", " + items + ")");
        this.m_idNamesTable[index] = items;
        Trace.trace(TRACE_MASKT, "<- SnmpBean.setNamesTableRowAt()");
    }

    public int getNamesTableRowCount() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getNamesTableRowCount()");
        return this.m_idNamesTable.length;
    }

    public int getNamesTableRowStatus() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getNamesTableRowStatus()");
        return 3;
    }

    public ColumnDescriptor[] getNamesTableRowStructure() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getNamesTableRowStructure()");
        return this.m_cdNamesTableStructure;
    }

    public void initializeNamesTableData(ArrayList tableData) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.initializeNamesTableData(" + tableData + ")");
        if (tableData.size() > 0) {
            this.nameList = (ArrayList)tableData.get(0);
            this.addressList = (ArrayList)tableData.get(1);
            this.networkMaskList = (ArrayList)tableData.get(2);
            this.accessTypeList = (ArrayList)tableData.get(3);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpBean.initializeNamesTableData()");
    }

    public void setPanelAppearance(String appearance) {
        this.appearance = appearance;
    }

    public void setTcpipTableSelection(int[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.setTcpipTableSelection(" + selected + ")");
        this.m_iTcpipTableSelection = selected;
        Trace.trace(TRACE_MASKT, "<- SnmpBean.setTcpipTableSelection()");
    }

    public int[] getTcpipTableSelection() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getTcpipTableSelection()");
        return this.m_iTcpipTableSelection;
    }

    public ItemDescriptor[] getTcpipTableRowAt(int index) {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getTcpipTableRowAt(" + index + ")");
        return this.m_idTcpipTable[index];
    }

    public void setTcpipTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.setTcpipTableRowAt(" + index + ", " + items + ")");
        this.m_idTcpipTable[index] = items;
        Trace.trace(TRACE_MASKT, "<- SnmpBean.setTcpipTableRowAt()");
    }

    public int getTcpipTableRowCount() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getTcpipTableRowCount()");
        return this.m_idTcpipTable.length;
    }

    public int getTcpipTableRowStatus() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getTcpipTableRowStatus()");
        return 3;
    }

    public ColumnDescriptor[] getTcpipTableRowStructure() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.getTcpipTableRowStructure()");
        return this.m_cdTcpipTableStructure;
    }

    public void initializeTcpipTableData(HashMap tableData) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.initializeTcpipTableData(" + tableData + ")");
        this.trapMap = tableData;
        Trace.trace(TRACE_MASKT, "<- SnmpBean.initializeTcpipTableData()");
    }

    private void addNamesTableRow(ArrayList rowData) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.addNamesTableRow(" + rowData + ")");
        this.nameList.add(rowData.get(0));
        this.addressList.add(rowData.get(1));
        this.networkMaskList.add(rowData.get(2));
        this.accessTypeList.add(rowData.get(3));
        this.populateNamesTable();
        int[] focusRow = new int[]{this.getNamesTableRowCount() - 1};
        this.setNamesTableSelection(focusRow);
        Trace.trace(TRACE_MASKT, "<- SnmpBean.addNamesTableRow()");
    }

    private void changeNamesTableRow(int index, ArrayList rowData) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.changeNamesTableRow(" + index + ", " + rowData + ")");
        this.nameList.set(index, rowData.get(0));
        this.addressList.set(index, rowData.get(1));
        this.networkMaskList.set(index, rowData.get(2));
        this.accessTypeList.set(index, rowData.get(3));
        this.populateNamesTable();
        int[] focusRow = new int[]{this.getNamesTableSelection()[0]};
        this.setNamesTableSelection(focusRow);
        Trace.trace(TRACE_MASKT, "<- SnmpBean.changeNamesTableRow()");
    }

    private void deleteNamesTableRow(int index) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.deleteNamesTableRow(" + index + ")");
        if (this.getNamesTableRowCount() > 0) {
            this.nameList.remove(index);
            this.addressList.remove(index);
            this.networkMaskList.remove(index);
            this.accessTypeList.remove(index);
            this.populateNamesTable();
            if (index == 0) {
                if (this.getNamesTableRowCount() > 0) {
                    int[] focusRow = new int[]{0};
                    this.setNamesTableSelection(focusRow);
                }
            } else {
                int[] focusRow = new int[]{index - 1};
                this.setNamesTableSelection(focusRow);
            }
        }
        Trace.trace(TRACE_MASKT, "<- SnmpBean.deleteNamesTableRow()");
    }

    private void populateNamesTable() {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.populateNamesTable()");
        this.m_idNamesTable = new ItemDescriptor[this.nameList.size()][4];
        for (int i = 0; i < this.nameList.size(); ++i) {
            ItemDescriptor[] row = new ItemDescriptor[]{new ItemDescriptor(this.getMountPrefix() + ":m_idNamesTable[" + String.valueOf(i) + "][0]", (String)this.nameList.get(i)), new ItemDescriptor(this.getMountPrefix() + ":m_idNamesTable[" + String.valueOf(i) + "][1]", (String)this.addressList.get(i)), new ItemDescriptor(this.getMountPrefix() + ":m_idNamesTable[" + String.valueOf(i) + "][2]", (String)this.networkMaskList.get(i)), new ItemDescriptor(this.getMountPrefix() + ":m_idNamesTable[" + String.valueOf(i) + "][3]", (String)this.accessTypeList.get(i))};
            this.setNamesTableRowAt(i, row);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpBean.populateNamesTable()");
    }

    private void addTcpipTableRow(ArrayList rowData) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.addTcpipTableRow(" + rowData + ")");
        this.tcpipList.add(rowData.get(0));
        this.populateTcpipTable();
        int[] focusRow = new int[]{this.getTcpipTableRowCount() - 1};
        this.setTcpipTableSelection(focusRow);
        Trace.trace(TRACE_MASKT, "<- SnmpBean.addTcpipTableRow()");
    }

    private void changeTcpipTableRow(int index, ArrayList rowData) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.changeTcpipTableRow(" + index + ", " + rowData + ")");
        this.tcpipList.set(index, rowData.get(0));
        this.populateTcpipTable();
        int[] focusRow = new int[]{this.getTcpipTableSelection()[0]};
        this.setTcpipTableSelection(focusRow);
        Trace.trace(TRACE_MASKT, "<- SnmpBean.changeTcpipTableRow()");
    }

    private void deleteTcpipTableRow(int index) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.deleteTcpipTableRow(" + index + ")");
        if (this.getTcpipTableRowCount() > 0) {
            this.tcpipList.remove(index);
            this.populateTcpipTable();
            if (index == 0) {
                if (this.getTcpipTableRowCount() > 0) {
                    int[] focusRow = new int[]{0};
                    this.setTcpipTableSelection(focusRow);
                }
            } else {
                int[] focusRow = new int[]{index - 1};
                this.setTcpipTableSelection(focusRow);
            }
        }
        Trace.trace(TRACE_MASKT, "<- SnmpBean.deleteTcpipTableRow()");
    }

    private void populateTcpipTable() {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.populateTcpipTable()");
        this.m_idTcpipTable = new ItemDescriptor[this.tcpipList.size()][1];
        for (int i = 0; i < this.tcpipList.size(); ++i) {
            ItemDescriptor[] row = new ItemDescriptor[]{new ItemDescriptor(this.getMountPrefix() + ":m_idTcpipTable[" + String.valueOf(i) + "][0]", (String)this.tcpipList.get(i))};
            this.setTcpipTableRowAt(i, row);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpBean.populateTcpipTable()");
    }

    public void update(Object updateObject) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.update(" + updateObject + ")");
        if (this.elementName.endsWith("TcpipAddButton")) {
            Trace.trace(TRACE_MASKD, "-> SnmpBean.update(): elementName = " + this.elementName);
            ArrayList updateData = (ArrayList)updateObject;
            Trace.trace(TRACE_MASKD, "SnmpBean.update(): updateData.get(0) = " + updateData.get(0));
            Trace.trace(TRACE_MASKD, "SnmpBean.update(): updateData.get(1) = " + updateData.get(1));
            String ipAddress = (String)updateData.get(0);
            ArrayList trapKeys = (ArrayList)updateData.get(1);
            this.trapMap.put(ipAddress, trapKeys);
            this.addTcpipTableRow(updateData);
            this.userTaskManager.refreshElement(this.getMountPrefix() + "TcpipTable");
        } else if (this.elementName.endsWith("TcpipChangeButton")) {
            Trace.trace(TRACE_MASKD, "SnmpBean.update(): elementName = " + this.elementName);
            int rowSelected = this.getTcpipTableSelection()[0];
            ArrayList updateData = (ArrayList)updateObject;
            Trace.trace(TRACE_MASKD, "SnmpBean.update(): updateData.get(0) = " + updateData.get(0));
            Trace.trace(TRACE_MASKD, "SnmpBean.update(): updateData.get(1) = " + updateData.get(1));
            ItemDescriptor[] row = this.getTcpipTableRowAt(this.getTcpipTableSelection()[0]);
            String selectedIpAddress = row[0].getTitle();
            String ipAddress = (String)updateData.get(0);
            if (!selectedIpAddress.equals(ipAddress)) {
                this.trapMap.remove(selectedIpAddress);
            }
            ArrayList trapKeys = (ArrayList)updateData.get(1);
            this.trapMap.put(ipAddress, trapKeys);
            this.changeTcpipTableRow(rowSelected, updateData);
            this.userTaskManager.refreshElement(this.getMountPrefix() + "TcpipTable");
        } else if (this.elementName.endsWith("AddButton")) {
            ArrayList rowData = (ArrayList)updateObject;
            this.addNamesTableRow(rowData);
            this.userTaskManager.refreshElement(this.getMountPrefix() + "NamesTable");
        } else if (this.elementName.endsWith("ChangeButton")) {
            ArrayList rowData = (ArrayList)updateObject;
            int rowSelected = this.getNamesTableSelection()[0];
            this.changeNamesTableRow(rowSelected, rowData);
            this.userTaskManager.refreshElement(this.getMountPrefix() + "NamesTable");
        }
        Trace.trace(TRACE_MASKT, "<- SnmpBean.update()");
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.verifyChanges()");
    }

    public void prepare() {
        int[] focusRow;
        Trace.trace(TRACE_MASKT, "-> SnmpBean.prepare()");
        this.populateNamesTable();
        if (this.getNamesTableRowCount() > 0) {
            focusRow = new int[]{0};
            this.setNamesTableSelection(focusRow);
        }
        this.tcpipList = new ArrayList(this.trapMap.keySet());
        this.populateTcpipTable();
        if (this.getTcpipTableRowCount() > 0) {
            focusRow = new int[]{0};
            this.setTcpipTableSelection(focusRow);
        }
        if ("TRAPS".equals(this.appearance)) {
            Trace.trace(TRACE_MASKF, "SnmpBean.prepare: setting 'traps only' appearance");
            this.userTaskManager.setShown(this.getMountPrefix() + "EnableToggle", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "AgentParmsEdit", false);
            this.userTaskManager.setShown(this.getMountPrefix() + "Group2", false);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpBean.prepare()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.load()");
        Trace.trace(TRACE_MASKT, "<- SnmpBean.load()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> SnmpBean.save()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.panelAction(" + event + ")");
        this.userTaskManager.storeAllElements();
        this.elementName = event.getElementName();
        if (this.elementName.endsWith("TcpipAddButton")) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("PANEL", "SnmpPanel");
            request.setData("EVENT", "ADD_IP");
            this.postTaskletRequest(request);
        } else if (this.elementName.endsWith("TcpipChangeButton")) {
            if (this.getTcpipTableRowCount() > 0) {
                ItemDescriptor[] row = this.getTcpipTableRowAt(this.getTcpipTableSelection()[0]);
                String ipAddress = row[0].getTitle();
                ArrayList selectedTraps = (ArrayList)this.trapMap.get(ipAddress);
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("PANEL", "SnmpPanel");
                request.setData("EVENT", "CHANGE_IP");
                request.setData("IP_ADDRESS", ipAddress);
                request.setData("SELECTED_TRAPS", selectedTraps);
                this.postTaskletRequest(request);
            }
        } else if (this.elementName.endsWith("TcpipDeleteButton")) {
            if (this.getTcpipTableRowCount() > 0) {
                int selectedRow = this.getTcpipTableSelection()[0];
                ItemDescriptor[] row = this.getTcpipTableRowAt(selectedRow);
                this.trapMap.remove(row[0].getTitle());
                this.deleteTcpipTableRow(selectedRow);
                this.userTaskManager.refreshElement(this.getMountPrefix() + "TcpipTable");
            }
        } else if (this.elementName.endsWith("AddButton")) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("PANEL", "SnmpPanel");
            request.setData("EVENT", "ADD_NAME");
            this.postTaskletRequest(request);
        } else if (this.elementName.endsWith("ChangeButton")) {
            if (this.getNamesTableRowCount() > 0) {
                ArrayList<String> rowData = new ArrayList<String>();
                ItemDescriptor[] row = this.getNamesTableRowAt(this.getNamesTableSelection()[0]);
                for (int i = 0; i < 4; ++i) {
                    rowData.add(row[i].getTitle());
                }
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("PANEL", "SnmpPanel");
                request.setData("EVENT", "CHANGE_NAME");
                request.setData("DATA", rowData);
                this.postTaskletRequest(request);
            }
        } else if (this.elementName.endsWith("DeleteButton")) {
            if (this.getNamesTableRowCount() > 0) {
                this.deleteNamesTableRow(this.getNamesTableSelection()[0]);
                this.userTaskManager.refreshElement(this.getMountPrefix() + "NamesTable");
            }
        } else if (this.elementName.endsWith("OKButton") || this.elementName.endsWith("ApplyButton")) {
            Trace.trace(TRACE_MASKT, "-> SnmpBean.panelAction, OKButton or ApplyButton");
            try {
                CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText(SNMP_MESSAGES_FILENAME, SNMP_MESSAGE_BOX_TITLE_KEY), new MessageText(SNMP_MESSAGES_FILENAME, SNMP_RESTART_CONSOLE_TEXT_KEY));
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("PANEL", "SnmpPanel");
            if (this.elementName.endsWith("OKButton")) {
                request.setData("EVENT", "OK");
            } else {
                request.setData("EVENT", "APPLY");
            }
            request.setData("SNMP_ENABLED", new Boolean(this.isEnableToggle()));
            request.setData("SNMP_PARMS", this.getAgentParmsEdit());
            ArrayList tableData = new ArrayList(this.getNamesTableRowCount());
            for (int i = 0; i < this.getNamesTableRowCount(); ++i) {
                ItemDescriptor[] row = this.getNamesTableRowAt(i);
                ArrayList<String> tableRow = new ArrayList<String>();
                tableRow.add(row[0].getTitle());
                tableRow.add(row[1].getTitle());
                tableRow.add(row[2].getTitle());
                tableRow.add(row[3].getTitle());
                tableData.add(tableRow);
            }
            request.setData("NAMES_TABLE", tableData);
            request.setData("TRAP_MAP", this.trapMap);
            this.postTaskletRequest(request);
        } else if (this.elementName.endsWith("CancelButton")) {
            Trace.trace(TRACE_MASKT, "-> SnmpBean.panelAction, CancelButton");
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("PANEL", "SnmpPanel");
            request.setData("EVENT", "CANCEL");
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpBean.panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        Trace.trace(TRACE_MASKT, "-> SnmpBean.parentalAction(" + event + ", " + parent + ")");
        this.elementName = event.getElementName();
        if (this.elementName.endsWith("OKButton")) {
            PanelTaskletRequest request = new PanelTaskletRequest(this.getBeanName());
            request.setData("PANEL", "SnmpPanel");
            request.setData("EVENT", "OK");
            request.setData("SNMP_ENABLED", new Boolean(this.isEnableToggle()));
            request.setData("SNMP_PARMS", this.getAgentParmsEdit());
            ArrayList tableData = new ArrayList(this.getNamesTableRowCount());
            for (int i = 0; i < this.getNamesTableRowCount(); ++i) {
                ItemDescriptor[] row = this.getNamesTableRowAt(i);
                ArrayList<String> tableRow = new ArrayList<String>();
                tableRow.add(row[0].getTitle());
                tableRow.add(row[1].getTitle());
                tableRow.add(row[2].getTitle());
                tableRow.add(row[3].getTitle());
                tableData.add(tableRow);
            }
            request.setData("NAMES_TABLE", tableData);
            request.setData("TRAP_MAP", this.trapMap);
            this.postTaskletRequest(request);
        } else if (this.elementName.endsWith("CancelButton")) {
            PanelTaskletRequest request = new PanelTaskletRequest(this.getBeanName());
            request.setData("PANEL", "SnmpPanel");
            request.setData("EVENT", "CANCEL");
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpBean.parentalAction()");
    }
}

